from django.views.decorators.http import require_http_methods

from staff.lib.decorators import (
    responding_json,
    use_request_lang,
    available_for_external,
)
from staff.lib.forms.errors import default_error

from ..controllers import ssh_key as ctl
from ..permissions.utils import observer_has_perm


@available_for_external
@responding_json
@require_http_methods(['GET', 'POST'])  # POST required cause this view used in edit_view
@observer_has_perm('ssh_keys')
@use_request_lang
def ssh_keys(request, login):
    try:
        result = list(ctl.get_initial(login))
    except ctl.SSHKeyError:
        return default_error(), 500

    return {'target': {'ssh_keys': result}} if result else {}
