from django.views.decorators.http import require_GET

from staff.lib.decorators import (
    responding_json,
    use_request_lang,
    available_for_external,
)

from staff.person_profile.controllers.ware import BotWareLoader
from staff.person_profile.permissions.utils import observer_has_perm


@available_for_external
@responding_json
@require_GET
@observer_has_perm('hardware')
@use_request_lang
def hardware(request, login):
    bot_ware = BotWareLoader(login)

    return {'target': {
        'hardware': bot_ware.hardware_as_dict()
    }}


@available_for_external
@responding_json
@require_GET
@observer_has_perm('software')
@use_request_lang
def software(request, login):
    bot_ware = BotWareLoader(login)

    return {'target': {
        'software': bot_ware.software_as_dict()
    }}
