from abc import ABCMeta, abstractmethod
from typing import Any, Dict

from staff.preprofile.action_context import ActionContext

JsonData = Dict[str, Any]


class AbstractBehaviour(metaclass=ABCMeta):

    @abstractmethod
    def create_form(self, action_context: ActionContext, data: JsonData = None):
        raise NotImplementedError()

    @abstractmethod
    def create_edit_form(self, action_context: ActionContext, initial_data: JsonData, data: JsonData = None):
        raise NotImplementedError()

    @abstractmethod
    def actions_on_create(self):
        raise NotImplementedError()

    @abstractmethod
    def actions_on_edit(self, action_context: ActionContext) -> Dict[str, bool]:
        raise NotImplementedError()

    @abstractmethod
    def form_type(self):
        raise NotImplementedError()

    @abstractmethod
    def on_new_model(self, action_context: ActionContext):
        raise NotImplementedError()

    @abstractmethod
    def is_approvable(self, action_context: ActionContext):
        raise NotImplementedError()

    @abstractmethod
    def is_prepareable(self) -> bool:
        raise NotImplementedError()

    @abstractmethod
    def is_editable(self) -> bool:
        raise NotImplementedError()

    @abstractmethod
    def is_cancelable(self) -> bool:
        raise NotImplementedError()

    @abstractmethod
    def on_after_create(self, action_context: ActionContext):
        raise NotImplementedError()

    @abstractmethod
    def on_after_change(self, action_context: ActionContext):
        raise NotImplementedError()
