from datetime import date

from django.conf import settings

from staff.preprofile.utils import launch_person_avatar_task
from staff.person.models import EMPLOYMENT

from staff.preprofile.controller_behaviours import AbstractBehaviour
from staff.preprofile.forms import ExternalConsultantForm
from staff.preprofile.models import FORM_TYPE, EMAIL_DOMAIN, PREPROFILE_STATUS


class ExternalConsultantBehaviour(AbstractBehaviour):
    def create_form(self, action_context, data=None):
        return ExternalConsultantForm(data=data, base_initial={'action_context': action_context})

    def create_edit_form(self, action_context, initial_data, data=None):
        return ExternalConsultantForm(initial=initial_data, data=data, base_initial={'action_context': action_context})

    def actions_on_create(self):
        return {'save': True, 'approve': False, 'adopt': False, 'create_link': False}

    def actions_on_edit(self, action_context):
        return {'save': False, 'approve': False, 'adopt': False, 'create_link': False}

    def form_type(self):
        return FORM_TYPE.EXTERNAL

    def on_new_model(self, action_context):
        action_context.preprofile.email_domain = EMAIL_DOMAIN.YANDEX_TEAM_RU
        action_context.preprofile.status = PREPROFILE_STATUS.APPROVED
        action_context.preprofile.organization_id = settings.ROBOTS_ORGANIZATION_ID
        action_context.preprofile.position_staff_text = 'Внешний консультант'
        action_context.preprofile.join_at = date.today()
        action_context.preprofile.employment_type = EMPLOYMENT.PARTIAL
        action_context.preprofile.office_id = settings.HOMIE_OFFICE_ID

    def is_editable(self):
        return False

    def is_cancelable(self):
        return False

    def is_prepareable(self):
        return False

    def is_approvable(self, action_context):
        return False  # Already created in approved status

    def on_after_create(self, action_context):
        launch_person_avatar_task(task_kwargs={'preprofile_ids': [action_context.preprofile.id]})

    def on_after_change(self, action_context):
        pass


AbstractBehaviour.register(ExternalConsultantBehaviour)
