from staff.preprofile.utils import launch_person_avatar_task
from staff.preprofile.controller_behaviours import AbstractBehaviour
from staff.preprofile.forms.femida_edit_form import FemidaEditForm
from staff.preprofile.models import FORM_TYPE


class FemidaEmployeeBehaviour(AbstractBehaviour):
    def create_form(self, action_context, data=None):
        raise NotImplementedError()

    def create_edit_form(self, action_context, initial_data, data=None):
        return FemidaEditForm(initial=initial_data, data=data, base_initial={'action_context': action_context})

    def actions_on_create(self):
        raise NotImplementedError()

    def actions_on_edit(self, action_context):
        pass

    def form_type(self):
        return FORM_TYPE.EMPLOYEE

    def on_new_model(self, action_context):
        pass

    def is_editable(self):
        return True

    def is_cancelable(self):
        return True

    def is_prepareable(self):
        return False

    def is_approvable(self, action_context):
        raise NotImplementedError()  # Should never be called

    def on_after_create(self, action_context):
        launch_person_avatar_task(task_kwargs={'preprofile_ids': [action_context.preprofile.id]})

    def on_after_change(self, action_context):
        pass


AbstractBehaviour.register(FemidaEmployeeBehaviour)
