from staff.preprofile.utils import launch_person_avatar_task
from staff.preprofile.controller_behaviours import AbstractBehaviour
from staff.preprofile.forms.femida_outstaff_external_form import FemidaOutstaffExternalForm
from staff.preprofile.models import FORM_TYPE


class FemidaOutstaffExternalBehaviour(AbstractBehaviour):
    def create_form(self, action_context, data=None):
        raise NotImplementedError()

    def create_edit_form(self, action_context, initial_data, data=None):
        return FemidaOutstaffExternalForm(
            initial=initial_data,
            data=data,
            base_initial={'model': action_context.preprofile},
        )

    def actions_on_create(self):
        raise NotImplementedError()

    def actions_on_edit(self, action_context):
        pass

    def form_type(self):
        return FORM_TYPE.OUTSTAFF

    def on_new_model(self, action_context):
        pass

    def is_editable(self):
        return True

    def is_cancelable(self):
        return False

    def is_prepareable(self):
        return True

    def is_approvable(self, action_context):
        raise NotImplementedError()  # Should never be called

    def on_after_create(self, action_context):
        pass

    def on_after_change(self, action_context):
        launch_person_avatar_task(task_kwargs={'preprofile_ids': [action_context.preprofile.id]})


AbstractBehaviour.register(FemidaOutstaffExternalBehaviour)
