from staff.preprofile.controller_behaviours import AbstractBehaviour
from staff.preprofile.forms import RotationEditForm
from staff.preprofile.models import FORM_TYPE


class FemidaRotationEditBehaviour(AbstractBehaviour):

    def create_form(self, action_context, data=None):
        raise NotImplementedError()

    def create_edit_form(self, action_context, initial_data, data=None):
        return RotationEditForm(initial=initial_data, data=data, base_initial={'action_context': action_context})

    def actions_on_create(self):
        pass

    def actions_on_edit(self, action_context):
        pass

    def form_type(self):
        return FORM_TYPE.ROTATION

    def on_new_model(self, action_context):
        raise NotImplementedError()

    def is_editable(self):
        return True

    def is_cancelable(self):
        return False

    def is_prepareable(self):
        return False

    def is_approvable(self, action_context):
        return True

    def on_after_create(self, action_context):
        raise NotImplementedError()

    def on_after_change(self, action_context):
        from staff.preprofile.tasks import AutoAdoptPreprofiles
        AutoAdoptPreprofiles(preprofile_id=action_context.preprofile.id)


AbstractBehaviour.register(FemidaRotationEditBehaviour)
