from staff.preprofile.controller_behaviours import AbstractBehaviour
from staff.preprofile.forms import AssignHelpdeskTicketForm


class HelpdeskBehaviour(AbstractBehaviour):
    def create_form(self, action_context, data=None):
        raise NotImplementedError()

    def create_edit_form(self, action_context, initial_data, data=None):
        return AssignHelpdeskTicketForm(data=data)

    def actions_on_create(self):
        raise NotImplementedError()

    def actions_on_edit(self, action_context):
        raise NotImplementedError()

    def form_type(self):
        raise NotImplementedError()

    def on_new_model(self, action_context):
        raise NotImplementedError()

    def is_prepareable(self):
        raise NotImplementedError()

    def is_editable(self):
        return True

    def is_cancelable(self):
        raise NotImplementedError()

    def is_approvable(self, action_context):
        raise NotImplementedError()  # Should never be called

    def on_after_create(self, action_context):
        raise NotImplementedError()

    def on_after_change(self, action_context):
        pass
