from django.conf import settings

from staff.person.models import EMPLOYMENT, LANG

from staff.preprofile.utils import launch_person_avatar_task
from staff.preprofile.controller_behaviours import AbstractBehaviour
from staff.preprofile.forms import YamoneyEmployeeForm
from staff.preprofile.models import PREPROFILE_STATUS, FORM_TYPE, EMAIL_DOMAIN


class YamoneyEmployeeBehavior(AbstractBehaviour):
    def create_form(self, action_context, data=None):
        return YamoneyEmployeeForm(data=data)

    def create_edit_form(self, action_context, initial_data, data=None):
        return YamoneyEmployeeForm(initial=initial_data, data=data, base_initial={'action_context': action_context})

    def actions_on_create(self):
        return {'save': True, 'approve': False, 'adopt': False, 'create_link': False}

    def actions_on_edit(self, action_context):
        if action_context.preprofile.status != PREPROFILE_STATUS.READY:
            return {'save': False, 'approve': False, 'adopt': False, 'create_link': False}

        can_be_saved = action_context.requested_by == action_context.preprofile.recruiter
        return {'save': can_be_saved, 'approve': False, 'adopt': False, 'create_link': False}

    def form_type(self):
        return FORM_TYPE.MONEY

    def on_new_model(self, action_context):
        action_context.preprofile.lang_ui = LANG.RU
        action_context.preprofile.organization_id = settings.YAMONEY_ORGANIZATION_ID
        action_context.preprofile.email_domain = EMAIL_DOMAIN.YAMONEY_RU
        action_context.preprofile.status = PREPROFILE_STATUS.APPROVED
        action_context.preprofile.employment_type = EMPLOYMENT.FULL

    def is_editable(self):
        return False

    def is_cancelable(self):
        return False

    def is_prepareable(self):
        return False

    def is_approvable(self, action_context):
        return False  # Already created in approved status

    def on_after_create(self, action_context):
        launch_person_avatar_task(task_kwargs={'preprofile_ids': [action_context.preprofile.id]})

    def on_after_change(self, action_context):
        pass


AbstractBehaviour.register(YamoneyEmployeeBehavior)
