from datetime import date

from django.conf import settings

from staff.person.models import EMPLOYMENT
from staff.preprofile.utils import launch_person_avatar_task
from staff.preprofile.controller_behaviours import AbstractBehaviour
from staff.preprofile.forms import ZombieForm
from staff.preprofile.models import FORM_TYPE, CANDIDATE_TYPE, PREPROFILE_STATUS


class ZombieBehaviour(AbstractBehaviour):
    def create_form(self, action_context, data=None):
        return ZombieForm(data=data)

    def create_edit_form(self, action_context, initial_data, data=None):
        return ZombieForm(data=data, initial=initial_data, base_initial={'model': action_context.preprofile})

    def actions_on_create(self):
        return {'save': True, 'approve': False, 'adopt': False, 'create_link': False}

    def actions_on_edit(self, action_context):
        return {'save': False, 'approve': False, 'adopt': False, 'create_link': False}

    def form_type(self):
        return FORM_TYPE.ZOMBIE

    def on_new_model(self, action_context):
        action_context.preprofile.employment_type = EMPLOYMENT.FULL
        action_context.preprofile.candidate_type = CANDIDATE_TYPE.NEW_EMPLOYEE
        action_context.preprofile.organization_id = settings.ROBOTS_ORGANIZATION_ID
        action_context.preprofile.office_id = settings.VIRTUAL_OFFICE_ID
        action_context.preprofile.join_at = date.today()
        action_context.preprofile.status = PREPROFILE_STATUS.APPROVED

    def is_editable(self):
        return False

    def is_cancelable(self):
        return False

    def is_prepareable(self):
        return False

    def is_approvable(self, action_context):
        return False  # Already created in approved status

    def on_after_create(self, action_context):
        launch_person_avatar_task(task_kwargs={'preprofile_ids': [action_context.preprofile.id]})

    def on_after_change(self, action_context):
        pass


AbstractBehaviour.register(ZombieBehaviour)
