from staff.lib.forms import errors as form_errors


class ControllerError(Exception):
    def __init__(self, errors_dict, *args, **kwargs):
        self.errors_dict = errors_dict
        super(ControllerError, self).__init__(*args, **kwargs)


class AccessDeniedControllerError(Exception):
    pass


def raise_controller_error(message_code):
    errors = form_errors.general_error({'message': message_code})
    raise ControllerError(errors_dict=errors)
