import sform
from django.core.exceptions import ValidationError

from staff.preprofile.login_validation import validate_login, MAX_ROBOT_LOGIN_LENGTH, MAX_LOGIN_LENGTH


class CheckLoginForm(sform.SForm):
    is_robot = sform.BooleanField(state=sform.REQUIRED)
    login = sform.CharField(max_length=max(MAX_ROBOT_LOGIN_LENGTH, MAX_LOGIN_LENGTH), state=sform.REQUIRED)
    preprofile_id = sform.IntegerField()

    def clean(self):
        cleaned_data = self.cleaned_data
        preprofile_id = cleaned_data.get('preprofile_id', None)

        try:
            validate_login(cleaned_data['login'], cleaned_data['is_robot'], preprofile_id)
        except ValidationError as e:
            self._errors[('login',)] = [e]
            return None

        return cleaned_data
