import sform

from staff.preprofile.forms.fields import (
    contacts_fields,
    official_fields,
    personal_fields,
    technical_fields,
)
from staff.preprofile.forms.utils import remove_readonly_fields
from staff.preprofile.forms.validation import validate_login_with_candidate_type
from staff.preprofile.models import CANDIDATE_TYPE


class FemidaOutstaffExternalForm(sform.SForm):
    first_name = personal_fields.first_name()
    last_name = personal_fields.last_name()
    middle_name = personal_fields.middle_name(required=False)
    first_name_en = personal_fields.first_name_en()
    last_name_en = personal_fields.last_name_en()
    gender = personal_fields.gender()
    birthday = personal_fields.birthday()
    photo = personal_fields.photo(required=False)
    citizenship = personal_fields.citizenship()

    phone = contacts_fields.phone()
    email = contacts_fields.email()
    address = contacts_fields.address()

    login = official_fields.human_login()
    join_at = official_fields.join_at()

    is_eds_phone_verified = technical_fields.is_eds_phone_verified(required=False)

    def clean(self):
        remove_readonly_fields(self)

        preprofile = self.base_initial['model']
        candidate_type = preprofile.candidate_type

        if preprofile.candidate_type == CANDIDATE_TYPE.FORMER_EMPLOYEE:
            return super(FemidaOutstaffExternalForm, self).clean()

        cleaned_data = self.cleaned_data

        if not cleaned_data.get('login', None):
            return super(FemidaOutstaffExternalForm, self).clean()

        login = cleaned_data['login']
        validate_login_with_candidate_type(login, candidate_type, preprofile.id)

        return super(FemidaOutstaffExternalForm, self).clean()

    def get_field_state(self, name):
        if name == 'login':
            preprofile = self.base_initial['model']
            if preprofile.candidate_type in (CANDIDATE_TYPE.FORMER_EMPLOYEE, CANDIDATE_TYPE.CURRENT_EMPLOYEE):
                return sform.READONLY

        return super(FemidaOutstaffExternalForm, self).get_field_state(name)
