import sform

from django.core import validators

from staff.preprofile.forms.fields.field_factory import field_factory
from staff.preprofile.forms.fields.stripped_char_field import StrippedCharField
from staff.preprofile.forms.validation import validate_phone
from staff.preprofile.utils import normalize_phone


class PhoneField(sform.CharField):
    def clean(self, new_value, old_value, required, trim_on_empty, base_initial, base_data):
        new_value = normalize_phone(new_value)
        return super().clean(new_value, old_value, required, trim_on_empty, base_initial, base_data)

    @property
    def type_name(self):
        return sform.CharField().type_name


phone = field_factory(PhoneField, max_length=100, validators=[validate_phone])
email = field_factory(StrippedCharField, max_length=100, validators=[validators.validate_email])
address = field_factory(StrippedCharField, max_length=1024)
