import sform


def field_factory(func, *args, **keywords):
    def newfunc(*fargs, **fkeywords):
        newkeywords = keywords.copy()
        newkeywords.update(fkeywords)

        required = newkeywords.pop('required', True)
        readonly = newkeywords.pop('readonly', False)

        if required and not readonly:
            newkeywords['state'] = sform.REQUIRED
        elif readonly:
            newkeywords['state'] = sform.READONLY
        elif readonly and required:
            raise RuntimeError('Unsupported combination')
        else:
            newkeywords['state'] = sform.NORMAL

        field = func(*(args + fargs), **newkeywords)
        return field

    newfunc.func = func
    newfunc.args = args
    newfunc.keywords = keywords
    return newfunc
