import sform

from staff.map.models import Table, Room
from staff.person.models import LANG

from staff.preprofile.forms.fields.field_factory import field_factory
from staff.preprofile.forms.fields.stripped_char_field import StrippedCharField
from staff.preprofile.models import OS_TYPE, NEED_TABLE, AUTOHIRE_HARDWARE_PROFILE_TYPE
from staff.preprofile.forms.fields.custom_fields import HardwareChoiceField

os = field_factory(sform.ChoiceField, choices=OS_TYPE.choices())
hardware_profile_description = field_factory(StrippedCharField, max_length=1000)
hardware_profile = field_factory(HardwareChoiceField)
hardware_profile_needs_table = field_factory(sform.BooleanField)
autohire_hardware_profile_type = field_factory(
    sform.ChoiceField,
    choices=AUTOHIRE_HARDWARE_PROFILE_TYPE.choices(),
    default=AUTOHIRE_HARDWARE_PROFILE_TYPE.NO,
)

need_vpn = field_factory(sform.BooleanField)
crm_alias = field_factory(sform.CharField, max_length=50)
lang_ui = field_factory(
    sform.ChoiceField,
    choices=[lang for lang in LANG.choices() if lang != ('tr', 'Turkish')],
    default=LANG.RU,
)

zombie_hw = field_factory(StrippedCharField, max_length=1500)
remote_access = field_factory(StrippedCharField)
network_connected = field_factory(sform.BooleanField)
need_tv = field_factory(sform.BooleanField)

need_table = field_factory(sform.ChoiceField, choices=NEED_TABLE.choices())
need_chair = field_factory(sform.BooleanField)
need_phone = field_factory(sform.BooleanField)

table = field_factory(sform.SuggestField, queryset=Table.objects.filter(intranet_status=1), label_fields='id')
room = field_factory(sform.SuggestField, queryset=Room.objects.filter(intranet_status=1), label_fields=('num', 'name',))

need_internal_phone = field_factory(sform.BooleanField)
need_sip_redirect = field_factory(sform.BooleanField)

need_internal_phone_unfilled = field_factory(sform.NullBooleanField)
need_sip_redirect_unfilled = field_factory(sform.NullBooleanField)
