import sform

from staff.person.models import GENDER

from staff.preprofile.models.preprofile import CITIZENSHIP
from staff.preprofile.forms import validation
from staff.preprofile.forms.fields.field_factory import field_factory
from staff.preprofile.forms.fields.stripped_char_field import StrippedCharField


def validate_first_name_en(value):
    value = value.strip()
    validation.validate_value_is_not_empty(value)
    validation.validate_name_en(value)


def validate_last_name_en(value):
    value = value.strip()
    validation.validate_value_is_not_empty(value)
    validation.validate_last_name_en(value)


def validate_first_name(value):
    value = value.strip()
    validation.validate_value_is_not_empty(value)
    validation.validate_name(value)


def validate_last_name(value):
    value = value.strip()
    validation.validate_value_is_not_empty(value)
    validation.validate_last_name(value)


def validate_middle_name(value):
    if not value:
        return

    value = value.strip()
    validation.validate_value_is_not_empty(value)
    validation.validate_middle_name(value)


photo = field_factory(StrippedCharField, max_length=255)
first_name_en = field_factory(
    StrippedCharField,
    max_length=50,
    state=sform.REQUIRED,
    validators=[validate_first_name_en],
)
last_name_en = field_factory(
    StrippedCharField,
    max_length=100,
    state=sform.REQUIRED,
    validators=[validate_last_name_en],
)
first_name = field_factory(StrippedCharField, max_length=30, state=sform.REQUIRED, validators=[validate_first_name])
last_name = field_factory(StrippedCharField, max_length=30, state=sform.REQUIRED, validators=[validate_last_name])
middle_name = field_factory(StrippedCharField, max_length=50, validators=[validate_middle_name])
gender = field_factory(sform.ChoiceField, choices=GENDER.choices())
birthday = field_factory(sform.DateField, validators=[validation.validate_date])
citizenship = field_factory(sform.ChoiceField, choices=CITIZENSHIP.choices())
