import sform
from django.core.exceptions import ValidationError

from staff.person.models import Staff

from staff.preprofile.forms.fields.field_factory import field_factory
from staff.preprofile.forms.fields.stripped_char_field import StrippedCharField
from staff.preprofile.models import PREPROFILE_STATUS, Preprofile

created_at = field_factory(sform.DateTimeField)
modified_at = field_factory(sform.DateTimeField)
status = field_factory(sform.ChoiceField, choices=PREPROFILE_STATUS.choices())

uid = field_factory(sform.CharField, max_length=16)
guid = field_factory(sform.CharField, max_length=47)

preprofile = field_factory(
    sform.SuggestField,
    queryset=Preprofile.objects.all(),
    to_field_name='id',
    label_fields=('first_name', 'last_name',),
)

chief = field_factory(
    sform.SuggestField,
    queryset=Staff.objects.filter(is_dismissed=False),
    to_field_name='login',
    label_fields=('first_name', 'last_name',),
)

hr_partner = field_factory(
    sform.SuggestField,
    queryset=Staff.objects.filter(is_dismissed=False),
    to_field_name='login',
    label_fields=('first_name', 'last_name',),
)

hr_partners = field_factory(
    sform.MultipleSuggestField,
    queryset=Staff.objects.filter(is_dismissed=False),
    to_field_name='login',
    label_fields={
        'caption': ('first_name', 'last_name'),
        'extra_fields': ['login'],
    },
)

recruiter = field_factory(
    sform.SuggestField,
    queryset=Staff.objects.filter(is_dismissed=False),
    to_field_name='login',
    label_fields=('first_name', 'last_name',),
)

approved_by = field_factory(
    sform.SuggestField,
    queryset=Staff.objects.filter(is_dismissed=False),
    to_field_name='login',
    label_fields=('first_name', 'last_name',),
)

adopted_by = field_factory(
    sform.SuggestField,
    queryset=Staff.objects.filter(is_dismissed=False),
    to_field_name='login',
    label_fields=('first_name', 'last_name',),
)

hr_ticket = field_factory(StrippedCharField, max_length=15)
adopt_ticket = field_factory(StrippedCharField, max_length=15)
ext_form_link = field_factory(StrippedCharField, max_length=128)


def validate_femida_offer_id(value):
    if Preprofile.objects.filter(femida_offer_id=value).exists():
        raise ValidationError(
            'Preprofile with such offer id already exists',
            code='femida_offer_id_exists',
            params=value,
        )


femida_offer_id = field_factory(sform.IntegerField, validators=[validate_femida_offer_id])
is_eds_phone_verified = field_factory(sform.BooleanField)
is_autohire = field_factory(sform.BooleanField)
