import sform

from staff.map.models import Office
from staff.person.models import Organization, Staff
from staff.preprofile.forms.fields import official_fields, technical_fields
from staff.preprofile.models import INTERNSHIP_FULLTIME, ROOT_DEPARTMENT, PREPROFILE_STATUS


class CustomStatusMultipleChoiceField(sform.MultipleChoiceField):
    def __init__(self, *args, **kwargs):
        super(CustomStatusMultipleChoiceField, self).__init__(PREPROFILE_STATUS.choices(), *args, **kwargs)

    def clean(self, new_value, old_value, required, trim_on_empty, base_initial, base_data):
        new_value = [st.upper() for st in new_value]
        return super().clean(new_value, old_value, required, trim_on_empty, base_initial, base_data)


class PersonFormsFilterForm(sform.SForm):

    office = sform.ModelMultipleChoiceField(
        state=sform.NORMAL,
        queryset=Office.objects.filter(intranet_status=1).order_by('name'),
        label_extractor='name',
    )
    org = sform.ModelMultipleChoiceField(
        state=sform.NORMAL,
        queryset=Organization.objects.filter(intranet_status=1).order_by('name'),
        label_extractor='name',
    )
    status = CustomStatusMultipleChoiceField(state=sform.NORMAL)
    preprofile = technical_fields.preprofile(required=False)
    chief = technical_fields.chief(required=False)
    hr_partner = technical_fields.hr_partner(required=False)
    department = official_fields.department(required=False)
    recruiter = sform.SuggestField(
        queryset=Staff.objects.all(),
        to_field_name='login',
        label_fields=('first_name', 'last_name',),
        state=sform.NORMAL,
    )
    date_from = sform.DateField(state=sform.NORMAL)
    date_to = sform.DateField(state=sform.NORMAL)
    internship_fulltime = sform.MultipleChoiceField(
        state=sform.NORMAL,
        choices=INTERNSHIP_FULLTIME,
    )
    root_department = sform.MultipleChoiceField(
        state=sform.NORMAL,
        choices=ROOT_DEPARTMENT,
    )

    def clean_status(self, lst):
        return [st.upper() for st in lst]
