import sform

from staff.preprofile.forms.fields import personal_fields, official_fields, technical_fields


class RobotForm(sform.SForm):
    photo = personal_fields.photo(required=False)
    birthday = personal_fields.birthday(required=False)
    first_name_en = personal_fields.first_name_en()
    first_name = personal_fields.first_name()
    last_name_en = personal_fields.last_name_en()
    last_name = personal_fields.last_name()
    middle_name = personal_fields.middle_name(required=False)
    gender = personal_fields.gender()

    department = official_fields.department(restrict_to_department_url='virtual')
    login = official_fields.robot_login()
    position_staff_text = official_fields.position_staff_text()
    abc_services = official_fields.abc_services()
    responsible = official_fields.responsible()

    uid = technical_fields.uid(readonly=True)
    guid = technical_fields.guid(readonly=True)
    created_at = technical_fields.created_at(readonly=True)
    modified_at = technical_fields.modified_at(readonly=True)
    status = technical_fields.status(readonly=True)
    chief = technical_fields.chief(readonly=True)
    hr_partners = technical_fields.hr_partners(readonly=True)

    def get_field_state(self, name):
        if 'model' in self.base_initial:
            return sform.READONLY

        return super(RobotForm, self).get_field_state(name)
