import sform

from staff.preprofile.forms.fields import (
    official_fields,
    technical_fields,
)

from staff.preprofile.forms.validation import validate_login_with_candidate_type


class RotationForm(sform.SForm):
    login = sform.CharField(state=sform.REQUIRED)
    office = official_fields.office(required=False)
    position = official_fields.position(required=False)
    position_staff_text = official_fields.position_staff_text(required=False)
    join_at = official_fields.join_at()
    department = official_fields.department()
    organization = official_fields.organization(required=False)
    abc_services = official_fields.femida_abc_services()
    employment_type = official_fields.employment_type(required=False)
    candidate_type = official_fields.candidate_type()
    date_completion_internship = official_fields.date_completion_internship()

    recruiter = technical_fields.recruiter()
    hr_ticket = technical_fields.hr_ticket(required=False)
    adopt_ticket = technical_fields.adopt_ticket(required=False)
    femida_offer_id = technical_fields.femida_offer_id()

    def clean(self):
        cleaned_data = self.cleaned_data

        if self._errors is None:
            login = cleaned_data['login']
            candidate_type = cleaned_data['candidate_type']

            validate_login_with_candidate_type(login, candidate_type)

        return cleaned_data
