import sform
import datetime
from staff.person.models import Staff


class RotationHistoryForm(sform.SForm):
    person = sform.ModelChoiceField(
        queryset=Staff.objects.all(),
        to_field_name='login',
        label_extractor='login',
    )
    from_date = sform.DateField(state=sform.REQUIRED, input_formats=('%Y-%m-%d', ))
    to_date = sform.DateField(input_formats=('%Y-%m-%d', ))

    def clean_to_date(self, value):
        return value or datetime.date.today() + datetime.timedelta(days=1)
