import sform

from staff.preprofile.forms.validation import validate_login_with_candidate_type
from staff.preprofile.forms.fields import official_fields, personal_fields, technical_fields
from staff.preprofile.models import CANDIDATE_TYPE


class YamoneyEmployeeForm(sform.SForm):
    first_name_en = personal_fields.first_name_en()
    last_name_en = personal_fields.last_name_en()
    first_name = personal_fields.first_name()
    last_name = personal_fields.last_name()
    middle_name = personal_fields.middle_name(required=False)
    gender = personal_fields.gender()

    login = official_fields.human_login()
    candidate_type = official_fields.candidate_type(
        without=[CANDIDATE_TYPE.EXTERNAL_EMPLOYEE, CANDIDATE_TYPE.CURRENT_EMPLOYEE],
    )
    position_staff_text = official_fields.position_staff_text()
    office = official_fields.office()
    join_at = official_fields.join_at()
    department = official_fields.department(restrict_to_department_url=['yandex_money', 'ex_yandex_money'])

    uid = technical_fields.uid(readonly=True)
    guid = technical_fields.guid(readonly=True)
    created_at = technical_fields.created_at(readonly=True)
    modified_at = technical_fields.modified_at(readonly=True)
    status = technical_fields.status(readonly=True)
    chief = technical_fields.chief(readonly=True)
    recruiter = technical_fields.recruiter(readonly=True)

    def get_field_state(self, name):
        is_editing = (
           'action_context' in self.base_initial
           and self.base_initial['action_context'].preprofile
        )
        if is_editing:
            return sform.READONLY

        return super(YamoneyEmployeeForm, self).get_field_state(name)

    def clean(self):
        cleaned_data = self.cleaned_data

        required_fields = ['login', 'candidate_type']

        if any([field not in cleaned_data for field in required_fields]):
            return None

        login = cleaned_data['login']
        candidate_type = cleaned_data['candidate_type']

        validate_login_with_candidate_type(login, candidate_type)

        return super(YamoneyEmployeeForm, self).clean()
