import sform

from staff.preprofile.forms.fields import personal_fields, technical_fields, official_fields, helpdesk_fields


class ZombieForm(sform.SForm):
    photo = personal_fields.photo(required=False)
    birthday = personal_fields.birthday(required=False)
    first_name_en = personal_fields.first_name_en()
    first_name = personal_fields.first_name()
    last_name_en = personal_fields.last_name_en()
    last_name = personal_fields.last_name()
    middle_name = personal_fields.middle_name(required=False)
    gender = personal_fields.gender()

    department = official_fields.department(restrict_to_department_url='virtual_robot')
    login = official_fields.zombie_login()
    position_staff_text = official_fields.position_staff_text()
    abc_services = official_fields.abc_services()
    responsible = official_fields.responsible()

    zombie_hw = helpdesk_fields.zombie_hw(required=False)
    remote_access = helpdesk_fields.remote_access(required=False)
    network_connected = helpdesk_fields.network_connected()
    need_tv = helpdesk_fields.need_tv()

    uid = technical_fields.uid(readonly=True)
    guid = technical_fields.guid(readonly=True)
    created_at = technical_fields.created_at(readonly=True)
    modified_at = technical_fields.modified_at(readonly=True)
    status = technical_fields.status(readonly=True)
    chief = technical_fields.chief(readonly=True)
    hr_partners = technical_fields.hr_partners(readonly=True)

    def get_field_state(self, name):
        if 'model' in self.base_initial:
            return sform.READONLY

        return super(ZombieForm, self).get_field_state(name)
