import logging
from typing import Optional

import ldap

from django.conf import settings

from staff.lib.ldap_helpers import LDAPContext

logger = logging.getLogger(__name__)


SEARCH_DN = [
    'CN=Users,DC=ld,DC=yandex,DC=ru',
    'OU=ForeignUsers,DC=ld,DC=yandex,DC=ru',
    'OU=TechUsers,DC=ld,DC=yandex,DC=ru',
    'OU=OLD Users,DC=ld,DC=yandex,DC=ru',
]


def get_guid_from_ldap(login: str) -> Optional[str]:
    query = '(sAMAccountName=%s)' % login

    with LDAPContext(settings.LDAP_HOST) as ad:
        for base_dn in SEARCH_DN:
            result = ad.search_s(
                base=base_dn,
                scope=ldap.SCOPE_SUBTREE,
                filterstr=query,
                attrlist=['objectGUID'],
            )

            if result:
                guid = result[0][1]['objectGUID'][0]
                guid = ''.join('%02x' % i for i in guid)
                return guid
    return None
