import random

from django.core.management.base import BaseCommand

from staff.lib.db import atomic
from staff.preprofile.models import Preprofile, PREPROFILE_STATUS, CANDIDATE_TYPE


class Command(BaseCommand):
    args = 'preprofile_id'
    help = 'Makes preprofile ready with random UID and GUID'

    def handle(self, *args, **options):
        with atomic():
            preprofile_id = args[0]
            preprofile = Preprofile.objects.get(id=preprofile_id)

            if preprofile.candidate_type == CANDIDATE_TYPE.NEW_EMPLOYEE:
                preprofile.uid = '{}'.format(random.randint(1, 2000000000))
                preprofile.guid = '{}'.format(random.randint(1, 2000000000))

            preprofile.status = PREPROFILE_STATUS.READY
            preprofile.save()
