# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='HardwareProfile',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('profile_id', models.CharField(max_length=10)),
                ('name', models.CharField(max_length=100)),
                ('comment', models.CharField(max_length=1000, blank=True)),
                ('url', models.CharField(max_length=300)),
            ],
        ),
        migrations.CreateModel(
            name='IllegalLogin',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('login', models.CharField(max_length=50, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='PersonAdoptApplication',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('login', models.CharField(max_length=50, db_index=True)),
                ('rfid_code', models.CharField(max_length=128, unique=True)),
                ('status', models.CharField(max_length=24, choices=[('new', 'new'), ('done', 'done'), ('failed', 'failed')])),
                ('status_reason', models.TextField()),
                ('first_name', models.CharField(max_length=256, blank=True)),
                ('last_name', models.CharField(max_length=256, blank=True)),
                ('offer_id', models.IntegerField(null=True)),
                ('adopter', models.ForeignKey(null=True, related_name='+', to='django_intranet_stuff.Staff')),
            ],
        ),
        migrations.CreateModel(
            name='Preprofile',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('form_type', models.CharField(max_length=10, choices=[('employee', 'employee'), ('rotation', 'rotation'), ('money', 'money'), ('robot', 'robot'), ('zombie', 'zombie'), ('external', 'external'), ('outstaff', 'outstaff'), ('masshire', 'masshire')])),
                ('status', models.CharField(max_length=15, choices=[('NEW', 'NEW'), ('PREPARED', 'PREPARED'), ('APPROVED', 'APPROVED'), ('READY', 'READY'), ('CLOSED', 'CLOSED'), ('CANCELLED', 'CANCELLED')])),
                ('candidate_type', models.CharField(max_length=25, choices=[('NEW_EMPLOYEE', 'new_employee'), ('FORMER_EMPLOYEE', 'former_employee'), ('EXTERNAL_EMPLOYEE', 'external_employee'), ('CURRENT_EMPLOYEE', 'current_employee')])),
                ('employment_type', models.CharField(max_length=1, null=True, choices=[('F', 'intranet_stuff.Staff_FullEmployment'), ('P', 'intranet_stuff.Staff_PartTimeEmployment'), ('D', 'intranet_stuff.Staff_SecondaryJob')])),
                ('position_staff_text', models.CharField(max_length=150)),
                ('position', models.CharField(max_length=150, null=True)),
                ('docs_and_hw_address', models.CharField(max_length=100)),
                ('photo', models.CharField(max_length=255, null=True)),
                ('first_name', models.CharField(max_length=30)),
                ('first_name_en', models.CharField(max_length=50)),
                ('middle_name', models.CharField(max_length=50, null=True)),
                ('last_name', models.CharField(max_length=30)),
                ('last_name_en', models.CharField(max_length=100)),
                ('join_at', models.DateField(db_index=True)),
                ('birthday', models.DateField(null=True)),
                ('citizenship', models.CharField(max_length=16, blank=True, null=True, choices=[('RUSSIAN', 'RUSSIAN'), ('BELORUSSIAN', 'BELORUSSIAN'), ('UKRAINIAN', 'UKRAINIAN'), ('KAZAKHSTAN', 'KAZAKHSTAN'), ('KYRGYZSTAN', 'KYRGYZSTAN'), ('ARMENIA', 'ARMENIA'), ('OTHER', 'OTHER')])),
                ('login', models.CharField(max_length=50, null=True)),
                ('phone', models.CharField(max_length=100, null=True)),
                ('email', models.CharField(max_length=100, null=True)),
                ('address', models.CharField(max_length=1024, null=True)),
                ('gender', models.CharField(max_length=1, choices=[('M', 'intranet_stuff.Staff_Male'), ('F', 'intranet_stuff.Staff_Female')])),
                ('ext_yndx_login', models.CharField(max_length=50, null=True)),
                ('os', models.CharField(max_length=15, null=True, choices=[('UBUNTU', 'UBUNTU'), ('KUBUNTU', 'KUBUNTU'), ('WINDOWS', 'WINDOWS'), ('MAC', 'MAC'), ('NO_OS', 'NO_OS')])),
                ('education_status', models.CharField(max_length=1, null=True, choices=[('S', 'intranet_stuff.Staff_SecondaryEducation'), ('I', 'intranet_stuff.Staff_HigherIncompleteEducation'), ('B', 'intranet_stuff.Staff_BachelorsDegreeEducation'), ('M', 'intranet_stuff.Staff_MastersDegreeEducation'), ('P', 'intranet_stuff.Staff_SpecialistDegreeEducation'), ('D', 'intranet_stuff.Staff_AcademicDegreeEducation')])),
                ('education_direction', models.CharField(max_length=1, null=True, choices=[('T', 'intranet_stuff.Staff_TechnicalDirection'), ('L', 'intranet_stuff.Staff_LiberalDirection'), ('N', 'intranet_stuff.Staff_NaturalDirection'), ('E', 'intranet_stuff.Staff_EconomicDirection'), ('B', 'intranet_stuff.Staff_BusinessDirection')])),
                ('education_place', models.CharField(max_length=255, null=True)),
                ('education_date', models.DateField(null=True)),
                ('crm_alias', models.CharField(max_length=50, null=True)),
                ('email_domain', models.CharField(max_length=20, default='yandex-team.ru', choices=[('yandex-team.ru', 'yandex-team.ru'), ('yandex-team.com.ua', 'yandex-team.com.ua'), ('yandex-team.com', 'yandex-team.com'), ('yandex-team.com.tr', 'yandex-team.com.tr'), ('yamoney.ru', 'yamoney.ru'), ('yaprobki.ru', 'yaprobki.ru')])),
                ('need_vpn', models.NullBooleanField()),
                ('lang_ui', models.CharField(max_length=2, null=True, default='ru', choices=[('en', 'English'), ('ru', 'Russian'), ('tr', 'Turkish')])),
                ('need_table', models.CharField(max_length=15, null=True, choices=[('NO', 'no'), ('YES', 'yes'), ('ALREADY_HAVE', 'already_have')])),
                ('need_chair', models.NullBooleanField()),
                ('need_phone', models.NullBooleanField()),
                ('hardware_profile_description', models.CharField(max_length=1000, null=True)),
                ('hardware_profile_needs_table', models.NullBooleanField()),
                ('zombie_hw', models.TextField(null=True)),
                ('remote_access', models.TextField(null=True)),
                ('network_connected', models.NullBooleanField()),
                ('need_tv', models.NullBooleanField()),
                ('need_internal_phone', models.NullBooleanField()),
                ('need_sip_redirect', models.NullBooleanField()),
                ('femida_offer_id', models.IntegerField(unique=True, null=True)),
                ('uid', models.CharField(max_length=16, null=True)),
                ('guid', models.CharField(max_length=47, null=True)),
                ('hr_ticket', models.CharField(max_length=15, null=True)),
                ('adopt_ticket', models.CharField(max_length=15, null=True)),
                ('hdrfs_ticket', models.CharField(max_length=15, null=True)),
                ('supply_ticket', models.CharField(max_length=15, null=True)),
                ('tools_ticket', models.CharField(max_length=15, null=True)),
                ('duties', models.CharField(max_length=1024, default='')),
                ('duties_en', models.CharField(max_length=1024, default='')),
                ('ext_form_link', models.CharField(max_length=128, default='')),
                ('masshire_tag', models.CharField(max_length=128, null=True, db_index=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('date_completion_internship', models.DateField(null=True, default=None)),
                ('is_eds_phone_verified', models.NullBooleanField()),
                ('is_autohire', models.NullBooleanField()),
            ],
            options={
                'permissions': (('can_view_all_preprofiles', 'Can see all preprofiles'), ('available_preprofile_for_externals', 'External subordinates can see pages preprofile/*'), ('can_create_yamoney', 'Can create Ya.Money preprofiles'), ('can_outstaff', 'Can create outstaff'), ('chief_that_can_adopt', 'Special CHIEF that can adopt'), ('can_manage_masshire', 'Can manage mass hire processes'), ('can_see_rotation_history', 'Can see rotation history')),
            },
        ),
        migrations.CreateModel(
            name='PreprofileABCServices',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('group', models.ForeignKey(to='django_intranet_stuff.Group')),
                ('preprofile', models.ForeignKey(to='preprofile.Preprofile')),
            ],
        ),
        migrations.CreateModel(
            name='ProfileForDepartment',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('order', models.IntegerField(default=0)),
                ('department', models.ForeignKey(to='django_intranet_stuff.Department')),
                ('profile', models.ForeignKey(to='preprofile.HardwareProfile')),
            ],
            options={
                'ordering': ['-order'],
            },
        ),
        migrations.AddField(
            model_name='preprofile',
            name='abc_services',
            field=models.ManyToManyField(to='django_intranet_stuff.Group', through='preprofile.PreprofileABCServices'),
        ),
        migrations.AddField(
            model_name='preprofile',
            name='adopted_by',
            field=models.ForeignKey(null=True, related_name='+', on_delete=django.db.models.deletion.SET_NULL, to='django_intranet_stuff.Staff'),
        ),
        migrations.AddField(
            model_name='preprofile',
            name='approved_by',
            field=models.ForeignKey(null=True, related_name='+', on_delete=django.db.models.deletion.SET_NULL, to='django_intranet_stuff.Staff'),
        ),
        migrations.AddField(
            model_name='preprofile',
            name='department',
            field=models.ForeignKey(to='django_intranet_stuff.Department'),
        ),
        migrations.AddField(
            model_name='preprofile',
            name='hardware_office',
            field=models.ForeignKey(null=True, related_name='+', on_delete=django.db.models.deletion.SET_NULL, to='django_intranet_stuff.Office'),
        ),
        migrations.AddField(
            model_name='preprofile',
            name='hardware_profile',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='preprofile.HardwareProfile'),
        ),
        migrations.AddField(
            model_name='preprofile',
            name='mentor',
            field=models.ForeignKey(null=True, related_name='+', on_delete=django.db.models.deletion.SET_NULL, to='django_intranet_stuff.Staff'),
        ),
        migrations.AddField(
            model_name='preprofile',
            name='office',
            field=models.ForeignKey(null=True, related_name='+', on_delete=django.db.models.deletion.SET_NULL, to='django_intranet_stuff.Office'),
        ),
        migrations.AddField(
            model_name='preprofile',
            name='organization',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_intranet_stuff.Organization'),
        ),
        migrations.AddField(
            model_name='preprofile',
            name='recruiter',
            field=models.ForeignKey(related_name='+', on_delete=django.db.models.deletion.PROTECT, to='django_intranet_stuff.Staff'),
        ),
        migrations.AddField(
            model_name='preprofile',
            name='robot_owner',
            field=models.ForeignKey(null=True, related_name='+', to='django_intranet_stuff.Staff'),
        ),
        migrations.AddField(
            model_name='preprofile',
            name='room',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_intranet_stuff.Room'),
        ),
        migrations.AddField(
            model_name='preprofile',
            name='table',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_intranet_stuff.Table'),
        ),
        migrations.AddField(
            model_name='personadoptapplication',
            name='preprofile',
            field=models.ForeignKey(null=True, to='preprofile.Preprofile'),
        ),
        migrations.AddField(
            model_name='hardwareprofile',
            name='departments',
            field=models.ManyToManyField(to='django_intranet_stuff.Department', through='preprofile.ProfileForDepartment'),
        ),
        migrations.AlterUniqueTogether(
            name='preprofileabcservices',
            unique_together=set([('group', 'preprofile')]),
        ),
    ]
