# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('preprofile', '0003_illegal_login_exact_match'),
    ]

    operations = [
        migrations.RunSQL(
            sql='''UPDATE preprofile_preprofile
                SET status = 'CANCELLED'
            WHERE status = 'NEW' AND login IN (SELECT login FROM preprofile_preprofile WHERE login IS NOT NULL AND status NOT IN ('CLOSED', 'CANCELLED') AND created_at < '2019-01-01' GROUP BY login HAVING COUNT(1) > 1);
            ''',
        ),
        migrations.RunSQL(
            sql='''CREATE UNIQUE INDEX preprofile_preprofile_login ON preprofile_preprofile(login) WHERE status NOT IN ('CLOSED', 'CANCELLED');''',
            reverse_sql='DROP INDEX preprofile_preprofile_login;',
        ),
    ]
