from django.db import models


class HardwareProfile(models.Model):
    profile_id = models.CharField(max_length=10)
    name = models.CharField(max_length=100)
    comment = models.CharField(max_length=1000, blank=True)
    url = models.CharField(max_length=300)
    departments = models.ManyToManyField('django_intranet_stuff.Department', through='ProfileForDepartment')

    def __str__(self):
        return ', '.join([self.profile_id, self.name])


class ProfileForDepartment(models.Model):
    department = models.ForeignKey('django_intranet_stuff.Department', on_delete=models.CASCADE)
    profile = models.ForeignKey(HardwareProfile, on_delete=models.CASCADE)
    order = models.IntegerField(default=0)

    class Meta:
        ordering = ['-order']
