from django.db import models
from staff.person.models import Staff

from staff.preprofile.models.preprofile import Preprofile

from staff.lib.utils.ordered_choices import OrderedChoices

STATUS = OrderedChoices(
    ('NEW', 'new'),
    ('DONE', 'done'),
    ('FAILED', 'failed'),
)


class PersonAdoptApplication(models.Model):
    login = models.CharField(max_length=50, db_index=True)
    rfid_code = models.CharField(unique=True, max_length=128)
    status = models.CharField(max_length=24, choices=STATUS)
    status_reason = models.TextField()

    first_name = models.CharField(max_length=256, blank=True)
    last_name = models.CharField(max_length=256, blank=True)

    offer_id = models.IntegerField(null=True)
    preprofile = models.ForeignKey(Preprofile, null=True)
    adopter = models.ForeignKey(Staff, null=True, related_name='+')
