from staff.lib.models.roles_chain import get_grouped_chiefs_by_departments
from staff.lib.utils.qs_values import extract_related


def fill_chief_and_departments_data(preprofiles):
    departments_list = [
        extract_related(preprofile, 'department', pop=False)
        for preprofile in preprofiles
    ]

    fields = ('login', 'first_name', 'last_name', 'middle_name')
    chiefs = get_grouped_chiefs_by_departments(departments_list, fields=fields)

    default = {
        'chief_login': '',
        'chief_first_name': '',
        'chief_last_name': '',
        'chief_middle_name': '',
        'chief_id': '',
    }

    for preprofile in preprofiles:
        dep_data = extract_related(preprofile, 'department')

        chief_data = extract_related(chiefs[dep_data['id']].copy(), 'staff', 'chief') or default.copy()
        del chief_data['chief_id']
        preprofile.update(chief_data)
        preprofile['department_name'] = dep_data['name']
        preprofile['department_url'] = dep_data['url']
