import json
import logging

from staff.preprofile.models.hardware_profile import HardwareProfile

from staff.lib.requests import Session
from staff.lib.sync_tools.datagenerators import DataGenerator


logger = logging.getLogger(__name__)


class ProfilesDataSource(object):
    class BotApiError(Exception):
        pass

    def __init__(self, settings):
        self.session = Session()
        self.session.headers['Authorization'] = 'OAuth {token}'.format(token=settings.ROBOT_STAFF_OAUTH_TOKEN)
        self.url = f'{settings.HELP_HOST}/api/profiles/list/old/'

    def _bot_request(self):
        response = self.session.get(self.url, timeout=10)

        if response.status_code != 200:
            raise self.BotApiError(response.content)

        return response.content

    def get_all_profiles(self):
        data = json.loads(self._bot_request())

        if data['error']:
            raise self.BotApiError(data['error'])

        for profile_arrays in data['result'].values():
            for profile in profile_arrays:
                yield profile


class ProfilesDataGenerator(DataGenerator):
    model = HardwareProfile
    sync_fields = ('profile_id', 'url')
    diff_fields = ('name', 'comment')

    def ext_data_gen(self):
        for profile in self.external_datasource.get_all_profiles():
            yield {
                'profile_id': str(profile['id']),
                'name': profile['name'],
                'comment': profile['comment'],
                'url': profile['url']
            }
