import logging
from django.core.exceptions import ValidationError

from staff.lib.utils.ordered_choices import OrderedChoices
from staff.map.models import Table, Room

from staff.preprofile.models import Preprofile

logger = logging.getLogger(__name__)

TABLE_VALIDATION_ERROR = OrderedChoices(
    ('INVALID_TABLE_FOR_OFFICE', 'invalid_table_for_office'),
    ('INVALID_ROOM_FOR_OFFICE', 'invalid_room_for_office'),
)


def validate_room(room: Room, preprofile: Preprofile) -> None:
    office = room.floor.office
    if office.id != preprofile.office.id:
        raise ValidationError(
            message='The room is not in the office',
            code=TABLE_VALIDATION_ERROR.INVALID_ROOM_FOR_OFFICE
        )


def validate_table(table: Table, preprofile: Preprofile) -> None:
    office = table.floor.office
    if office.id != preprofile.office.id:
        raise ValidationError(
            message='The table is not in the office',
            code=TABLE_VALIDATION_ERROR.INVALID_TABLE_FOR_OFFICE
        )
