from django import template
from django.conf import settings
from django.core.urlresolvers import reverse

from staff.lib.models.roles_chain import direct_chief_for_department
from staff.lib.models.departments_chain import get_departments_tree
from staff.preprofile.models import NEED_TABLE


register = template.Library()


@register.simple_tag
def preprofile_fio(preprofile, with_middle_name=False):
    return ' '.join([_f for _f in (
        preprofile.first_name,
        preprofile.middle_name if with_middle_name else None,
        preprofile.last_name
    ) if _f])


@register.simple_tag
def preprofile_need_table(preprofile):
    return {
        NEED_TABLE.ALREADY_HAVE: 'уже есть',
        NEED_TABLE.YES: 'да',
        NEED_TABLE.NO: 'нет',
    }.get(preprofile.need_table)


@register.simple_tag
def department_chief(department):
    return direct_chief_for_department(department, fields=['login']).get('login', '')


@register.simple_tag
def department_url(department):
    return ''.join((
        'https://',
        settings.STAFF_DOMAIN,
        reverse('departments-frontend:department', args=[department.url]),
    ))


@register.simple_tag
def staff_url(preprofile):
    return ''.join((
        'https://',
        settings.STAFF_DOMAIN,
        '/',
        preprofile.login,
    ))


@register.simple_tag
def department_chain(department):
    dep_chain = get_departments_tree([department.id], ['name']).popitem()[1]
    return '/'.join(it['name'] for it in dep_chain)


@register.simple_tag
def preprofile_url(preprofile):
    return f'https://{settings.STAFF_DOMAIN}/preprofile/{str(preprofile.id)}'
