import yenv

from django.conf.urls import url

from staff.preprofile import views

urlpatterns = [
    url(r'^adopt_persons/?$', views.adopt_persons, name='adopt_persons'),
    url(r'^adopt_status/?$', views.adopt_status, name='adopt_status'),
    url(r'^adopt_masshire/(?P<tag>[a-z]+)/?$', views.adopt_masshire, name='adopt_masshire'),
    url(r'^check_masshire_status/(?P<tag>[a-z]+)/?$', views.check_masshire_status, name='check_masshire_status'),


    url(r'^form/create_from_femida/?$', views.create_from_femida, name='create_from_femida'),
    url(r'^form/(?P<form_type>[a-z]+)/?$', views.new_form, name='new_form'),
    url(r'^form-api/(?P<form_type>[a-z]+)/?$', views.new_form_api, name='new_form_api'),

    url(r'^form/(?P<preprofile_id>\d+)/?$', views.edit_form, name='edit_form'),
    url(r'^form/(?P<preprofile_id>\d+)/femida_update/?$', views.femida_update, name='femida_update'),

    url(r'^form/(?P<preprofile_id>\d+)/cancel/?$', views.cancel_form, name='cancel_form'),
    url(r'^form/(?P<preprofile_id>\d+)/approve/?$', views.approve, name='approve'),
    url(r'^form/(?P<preprofile_id>\d+)/adopt/?$', views.adopt, name='adopt'),
    url(r'^form/(?P<preprofile_id>\d+)/create_link/?$', views.create_link, name='create_link'),
    url(
        r'^form/(?P<preprofile_id>\d+)/submit_ext_form/?$',
        views.femida_submit_external_form,
        name='femida_submit_external_form',
    ),

    url(r'^form-suggest/hardware_profile/?$', views.suggest_hardware_profile, name='suggest_hardware_profile'),
    url(r'^form-suggest/preprofile/?$', views.suggest_preprofile, name='suggest_preprofile'),

    url(r'^import/outstaff/?$', views.outstaff_mass_import, name='outstaff_mass_import'),

    url(r'^/?$', views.person_forms, name='person_forms'),

    url(r'^export/certificator/?$', views.certificator_export, name='certificator_export'),
    url(r'^export/puncher/?$', views.puncher_export, name='puncher_export'),
    url(r'^export/idm/?$', views.idm_export, name='idm_export'),
    url(r'^export/femida/?$', views.femida_export, name='femida_export'),
    url(r'^export/cab/?$', views.cab_export, name='cab_export'),
    url(r'^export/helpdesk/?$', views.helpdesk_export, name='helpdesk_export'),
    url(r'^export/masshire/?$', views.masshire_export, name='masshire_export'),
    url(r'^export/person-forms/?$', views.preprofile_export, name='preprofile_export'),
    url(r'^export/rotation_history/?$', views.person_rotation_history, name='person_rotation_history'),


    url(r'^check_login_availability/?$', views.check_login_availability, name='check_login_availability'),
    url(
        regex=r'^update_helpdesk_ticket/(?P<preprofile_id>\d+)/?$',
        view=views.update_helpdesk_ticket,
        name='update_helpdesk_ticket',
    ),

    url(r'^digital_sign/attach/?$', views.femida_ds_attach_phone, name='femida_ds_attach_phone'),
    url(r'^digital_sign/verify/?$', views.femida_ds_verify_phone, name='femida_ds_verify_phone'),
]

if yenv.choose_key_by_type(dict(testing=True, production=False), fallback=True):
    # for debug notifications
    urlpatterns += [
        url(r'^(?P<id>\d+)/notifications/?$', views.notification_list, name='notification_list'),
        url(r'^(?P<id>\d+)/notifications/(?P<type_>[\w\-]+)/?$', views.render_notification, name='render_notification'),
    ]
