from typing import Iterable

from staff.person.models import Staff

from staff.preprofile.repository import Repository


def full_data_model(requested_by: Staff) -> Iterable:
    fields = (
        'id',
        'address',
        'adopted_by__login',
        'approved_by__login',
        'birthday',
        'candidate_type',
        'created_at',
        'crm_alias',
        'department__name',
        'department__url',
        'email',
        'email_domain',
        'employment_type',
        'ext_form_link',
        'first_name',
        'first_name_en',
        'form_type',
        'gender',
        'guid',
        'hardware_profile__profile_id',
        'hardware_profile__name',
        'hardware_profile__comment',
        'hardware_profile_description',
        'hdrfs_ticket',
        'hr_ticket',
        'join_at',
        'lang_ui',
        'last_name',
        'last_name_en',
        'login',
        'middle_name',
        'modified_at',
        'need_chair',
        'need_phone',
        'need_table',
        'need_vpn',
        'office__name',
        'office__city__name',
        'organization__name',
        'os',
        'phone',
        'photo',
        'position',
        'position_staff_text',
        'recruiter__login',
        'room__id',
        'status',
        'table__id',
        'uid',
    )

    return Repository(requested_by).preprofiles_qs().values(*fields)
