from typing import Iterable

from staff.lib import xlsx


_HEADINGS = [
    'N/N',
    'Анкета в наниматоре',
    'Статус препрофайла',
    'Дата выхода на работу',
    'Фамилия',
    'Имя',
    'Отчество',
    'Фамилия лат.',
    'Имя лат.',
    'Логин',
    'Должность на стаффе',
    'Кадровая должность',
    'Ссылка на фото',
    'Телефон',
    'Почта',
    'Адрес',
    'ID Юридического лица*',
    'Подразделение',
    'Офис',
    'Номер комнаты',
    'Номер стола',
    'Пол',
    'Дата рождения',
    'Желаемая OS',
    'Нужен стол?',
    'Нужен стул?',
    'Нужен телефон?',
    'Нужен VPN?',
    'Язык интерфейса',
    'Аллиас в CRM',
    'Дата изменения',
    'Дата создания',
    'Кто вывел',
    'Кто утвердил',
    'Кто рекрутер',
    'Кто руководитель',
    'Кто партнер',
    'Тип кандидата',
    'UID',
    'GUID',
    'Профиль оборудования - название',
    'Профиль оборудования - описание',
    'Профиль оборудования - ID',
    'Комментарий к оборудованию',
    'Ссылка на внешнюю анкету (характерно для типа препрофайла outstaff)',
    'Тикет в очереди JOB',
    'Тикет в очереди HDRFS',
]


class FullDataSheetPresenter(xlsx.SheetPresenter):
    sheet_name = 'Данные'

    _font_base = {
        'font_name': 'Yandex Sans Display Light',
        'font_size': 12,
    }

    _heading_row_format = {
        'align': 'center',
        'valign': 'vcenter',
        'text_wrap': True,
        'bold': True,
        'bg_color': '#B4C6E7',
        **_font_base,
    }

    _data_row_format = {
        'border': 1,
        **_font_base,
    }
    fields_for_xlsx = (
        'idx',
        'id',
        'status',
        'join_at',
        'last_name',
        'first_name',
        'middle_name',
        'last_name_en',
        'first_name_en',
        'login',
        'position_staff_text',
        'position',
        'photo',
        'phone',
        'email',
        'address',
        'organization__name',
        'department__name',
        'office__name',
        'room__id',
        'table__id',
        'gender',
        'birthday',
        'os',
        'need_table',
        'need_chair',
        'need_phone',
        'need_vpn',
        'lang_ui',
        'crm_alias',
        'modified_at',
        'created_at',
        'adopted_by__login',
        'approved_by__login',
        'recruiter__login',
        'chief',
        'hr_partners',
        'employment_type',
        'uid',
        'guid',
        'hardware_profile__name',
        'hardware_profile__comment',
        'hardware_profile__profile_id',
        'hardware_profile_description',
        'ext_form_link',
        'hr_ticket',
        'hdrfs_ticket',
    )

    def __init__(self, model: Iterable):
        super().__init__(model=model)

    def columns(self) -> Iterable[xlsx.Column]:
        return self.auto_columns()

    def rows(self) -> Iterable[xlsx.ViewRow]:
        yield self.column_captions_row()
        yield from self.data_rows()

    def data_rows(self):
        for row in self._model:
            yield self.default_view_row_from_row_data(row[field] for field in self.fields_for_xlsx)

    def column_captions_row(self) -> xlsx.ViewRow:
        return xlsx.ViewRow(
            cells=xlsx.SheetPresenter.default_view_cells_from_row_data(_HEADINGS),
            row_format=self._heading_row_format,
        )
