from typing import Iterable

from staff.lib import xlsx


class CitizenshipPagePresenter(xlsx.SheetPresenter):
    sheet_name = 'Гражданства'

    _caption_row_format = {
        'bold': True,
        'font_size': 12,
    }

    def __init__(self):
        model = [
            ('Российское',),
            ('Белорусское',),
            ('Украинское',),
            ('Казахстанское',),
            ('Киргизское',),
            ('Армянское',),
            ('Другое',),
        ]
        super().__init__(model)

    def columns(self) -> Iterable[xlsx.Column]:
        return [xlsx.Column(width=89.08)]

    def rows(self) -> Iterable[xlsx.ViewRow]:
        yield xlsx.ViewRow(
            cells=[xlsx.ViewCell('Возможные для выбора гражданства сотрудников:')],
            row_format=self._caption_row_format,
        )
        yield from self.default_view_rows_from_data_model()
