from typing import Iterable, List

from staff.person.models import Staff
from staff.preprofile.repository import Repository


def data_model(requested_by: Staff, tags: List[str]) -> Iterable:
    fields = (
        'masshire_tag',
        'id',
        'first_name',
        'first_name_en',
        'middle_name',
        'last_name',
        'last_name_en',
        'login',
        'gender',
        'email',
        'phone',
        'address',
        'organization__name',
        'department__url',
        'position',
        'citizenship',
    )

    return Repository(requested_by).preprofiles_for_masshire_export(tags).values(*fields)
