def raw_data(token):
    """
    Из словаря, формируемого по .data_as_dict(), возвращает структуру такую же,
    как нам присылает фронт - данные без доп. полей.
    :return:
    """
    if isinstance(token, dict):
        result_dict = dict.fromkeys(token.keys())
        for key, value in token.items():
            if isinstance(value, dict):
                result_dict[key] = raw_data(value['value'])
            else:
                result_dict[key] = value
        return result_dict
    if isinstance(token, list):
        return [
            {k: raw_data(v) for k, v in item}
            for item in token
        ]
    return token
