import sform
from django.utils.encoding import smart_text


class DepartmentSuggestFieldBase(sform.SuggestField):
    type_name = 'suggest'
    suggest_type: str = None

    def structure_as_dict(self, *args, **kwargs):
        field_dict = super().structure_as_dict(*args, **kwargs)
        field_dict['types'] = [self.suggest_type]
        return field_dict

    def data_as_dict(self, value, prefix, name, state, *args, **kwargs):
        field_dict = self._get_base_field_dict(prefix, name, state)
        field_dict['value'] = value

        if field_dict['value'] in (None, ''):
            field_dict['caption'] = ''
        else:
            db_object = (
                self.queryset
                .filter(**{self.to_field_name: field_dict['value']})
                .values_list(*self.get_label_fields())
                .first()
             ) or {}

            field_dict['caption'] = ' '.join(smart_text(field) for field in db_object)

        return field_dict


class ValueStreamField(DepartmentSuggestFieldBase):
    suggest_type: str = 'main_product'


class GeographyField(DepartmentSuggestFieldBase):
    suggest_type: str = 'oebs_geography'
