import sform
from django import forms
from django.core.exceptions import ValidationError

from staff.departments.models import Department
from staff.person.models import Staff
from staff.map.models import Office


IMPORT_FILE_MAX_SIZE = 10*1024*1024


class FileImportForm(forms.Form):
    import_file = forms.FileField(max_length=IMPORT_FILE_MAX_SIZE)


class ChangeDepartmentForm(sform.SForm):
    person = sform.ModelChoiceField(
        queryset=Staff.objects.filter(is_dismissed=False),
        to_field_name='login',
        label_extractor='login',
        state=sform.REQUIRED,
    )
    department = sform.SuggestField(
        queryset=Department.objects.filter(intranet_status=1),
        to_field_name='url',
        label_fields=('name', 'url'),
        state=sform.REQUIRED,
    )
    comment = sform.CharField(max_length=2048)


class RecalculateSchemesForm(sform.SForm):
    person = sform.ModelChoiceField(
        queryset=Staff.objects.all(),
        to_field_name='login',
        label_extractor='login',
        state=sform.REQUIRED,
    )
    comment = sform.CharField(max_length=2048)


class ChangeOfficeSchemesForm(sform.SForm):
    person = sform.ModelChoiceField(
        queryset=Staff.objects.all(),
        to_field_name='login',
        label_extractor='login',
        state=sform.REQUIRED,
    )
    office = sform.ModelChoiceField(
        queryset=Office.objects.all(),
        to_field_name='name',
        label_extractor='name',
        state=sform.REQUIRED,
    )
    comment = sform.CharField(max_length=2048)


class BaseMassForm(sform.SForm):
    def clean_rows(self, value):
        if not value:
            raise ValidationError('Rows should not be empty', code='empty_rows')

        return value


class MassChangeDepartmentForm(BaseMassForm):
    rows = sform.GridField(sform.FieldsetField(ChangeDepartmentForm))


class MassRecalculateSchemesForm(BaseMassForm):
    rows = sform.GridField(sform.FieldsetField(RecalculateSchemesForm))


class MassChangeOfficeSchemesForm(BaseMassForm):
    rows = sform.GridField(sform.FieldsetField(ChangeOfficeSchemesForm))
