import sform

from staff.person.models import Staff
from staff.departments.models import Department


class PersonsToSplitForm(sform.SForm):
    persons = sform.MultipleSuggestField(
        queryset=Staff.objects.filter(is_dismissed=False),
        to_field_name='login',
        label_fields={
            'caption': ('first_name', 'last_name'),
            'extra_fields': ['login'],
        },
    )
    departments = sform.MultipleSuggestField(
        queryset=Department.objects.filter(intranet_status=1),
        to_field_name='id',
        label_fields={
            'caption': ('name',),
            'extra_fields': ['url'],
        },
    )
