from datetime import date, datetime
from typing import Dict, Union

import attr

from staff.departments.models import HrDeadline


@attr.s(auto_attribs=True)
class Deadline:
    deadline_date: date
    month: date
    type: str


class NearestDeadline:
    def _ensure_date(self, date_or_datetime: Union[date, datetime]):
        if isinstance(date_or_datetime, datetime):
            return date_or_datetime.date()

        return date_or_datetime

    def find_for_deadline_type(self, for_date: date, deadline_type: str) -> Deadline:
        first = HrDeadline.objects.filter(date__gte=for_date, type=deadline_type).order_by('date').first()
        return Deadline(type=first.type, deadline_date=first.date, month=self._ensure_date(first.month))

    def find(self, for_date: date) -> Dict[str, Deadline]:
        qs = (
            HrDeadline.objects
            .filter(date__gte=for_date)
            .order_by('type', 'date')
            .distinct('type')
            .values_list('type', 'month', 'date')
        )

        return {
            deadline_type: Deadline(deadline_date, month, deadline_type)
            for deadline_type, month, deadline_date in qs
        }
