# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0001_initial'),
        ('departments', '0002_auto_20211007_1807'),
    ]

    operations = [
        migrations.CreateModel(
            name='CityAttrs',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('component', models.IntegerField(verbose_name='Стартречный компонент', blank=True, null=True)),
                ('city', models.OneToOneField(verbose_name='Город', blank=True, null=True, related_name='attrs', to='django_intranet_stuff.City')),
                ('hr', models.ForeignKey(verbose_name='Кадровик', blank=True, null=True, related_name='+', to='django_intranet_stuff.Staff')),
            ],
            options={
                'verbose_name': 'Атрибуты для города',
                'verbose_name_plural': 'Атрибуты для городов',
                'db_table': 'wish_form_cityattrs',
            },
        ),
        migrations.CreateModel(
            name='DepartmentAttrs',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('budget_tag', models.CharField(verbose_name='Тэг бюджета', max_length=50, blank=True)),
                ('analyst', models.ForeignKey(verbose_name='Аналитик', blank=True, null=True, related_name='+', to='django_intranet_stuff.Staff')),
                ('budget_notify', models.ManyToManyField(verbose_name='Наблюдатели в создаваемом тикете', related_name='_departmentattrs_budget_notify_+', to='django_intranet_stuff.Staff')),
                ('budget_owner', models.ForeignKey(verbose_name='Держатель бюджета', blank=True, null=True, related_name='+', to='django_intranet_stuff.Staff')),
                ('department', models.OneToOneField(verbose_name='Подразделение', blank=True, null=True, to='django_intranet_stuff.Department')),
                ('ticket_access', models.ManyToManyField(verbose_name='Имеющие доступ к тикету', related_name='departmentattrs_accessing', to='django_intranet_stuff.Staff')),
            ],
            options={
                'verbose_name': 'Атрибуты для подразделения',
                'verbose_name_plural': 'Атрибуты для подразделений',
                'db_table': 'wish_form_departmentattrs',
            },
        ),
        migrations.CreateModel(
            name='Grade',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('level', models.CharField(verbose_name='Изменение уровня', max_length=32)),
                ('sort_order', models.IntegerField(verbose_name='Порядковый номер в списке', default=0)),
                ('name', models.CharField(verbose_name='Название', max_length=1024)),
                ('name_en', models.CharField(verbose_name='Название (англ)', max_length=1024)),
            ],
            options={
                'verbose_name': 'Уровень должности',
                'verbose_name_plural': 'Уровни должностей',
                'db_table': 'wish_form_grade',
            },
        ),
        migrations.CreateModel(
            name='ProposalTasksQueue',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('args', models.TextField()),
                ('callable', models.CharField(max_length=128)),
                ('module', models.CharField(max_length=512)),
                ('fail_count', models.IntegerField(default=0)),
                ('proposal', models.ForeignKey(to='departments.ProposalMetadata')),
            ],
        ),
    ]
