from django.db import models

from staff.departments.models import ProposalMetadata


class Grade(models.Model):
    level = models.CharField(
        max_length=32,
        verbose_name='Изменение уровня',
    )
    sort_order = models.IntegerField(
        verbose_name='Порядковый номер в списке',
        default=0,
    )
    name = models.CharField(
        max_length=1024,
        verbose_name='Название',
    )
    name_en = models.CharField(
        max_length=1024,
        verbose_name='Название (англ)',
    )

    class Meta:
        verbose_name = 'Уровень должности'
        verbose_name_plural = 'Уровни должностей'
        db_table = 'wish_form_grade'


class DepartmentAttrs(models.Model):
    department = models.OneToOneField(
        'django_intranet_stuff.Department',
        verbose_name='Подразделение',
        null=True,
        blank=True,
    )
    analyst = models.ForeignKey(
        'django_intranet_stuff.Staff',
        related_name='+',
        null=True,
        verbose_name='Аналитик',
        blank=True,
    )
    budget_owner = models.ForeignKey(
        'django_intranet_stuff.Staff',
        related_name='+',
        null=True,
        verbose_name='Держатель бюджета',
        blank=True,
    )
    budget_notify = models.ManyToManyField(
        'django_intranet_stuff.Staff',
        related_name='+',
        verbose_name='Наблюдатели в создаваемом тикете',
    )
    ticket_access = models.ManyToManyField(
        'django_intranet_stuff.Staff',
        related_name='departmentattrs_accessing',
        verbose_name='Имеющие доступ к тикету',
    )
    budget_tag = models.CharField(
        max_length=50,
        verbose_name='Тэг бюджета',
        blank=True,
    )

    class Meta:
        verbose_name = 'Атрибуты для подразделения'
        verbose_name_plural = 'Атрибуты для подразделений'
        db_table = 'wish_form_departmentattrs'

    def __str__(self):
        analyst_login = self.analyst and self.analyst.login
        department_url = self.department and self.department.url

        return f'<DepartmentAttrs>: {department_url} (Analyst: {analyst_login})'


class CityAttrs(models.Model):
    city = models.OneToOneField(
        'django_intranet_stuff.City',
        verbose_name='Город',
        null=True,
        blank=True,
        related_name='attrs',
    )
    hr = models.ForeignKey(
        'django_intranet_stuff.Staff',
        related_name='+',
        null=True,
        verbose_name='Кадровик',
        blank=True,
    )
    component = models.IntegerField(
        verbose_name='Стартречный компонент',
        blank=True,
        null=True,
    )

    class Meta:
        verbose_name = 'Атрибуты для города'
        verbose_name_plural = 'Атрибуты для городов'
        db_table = 'wish_form_cityattrs'


class ProposalTasksQueue(models.Model):
    proposal = models.ForeignKey(ProposalMetadata, null=False)
    args = models.TextField()
    callable = models.CharField(max_length=128)
    module = models.CharField(max_length=512)
    fail_count = models.IntegerField(default=0, null=False)
