from django.conf.urls import url

from staff.proposal import views

urlpatterns = [
    url(r'^list/?$', views.proposals_list, name='proposals_list'),
    url(r'^form/?$', views.add_proposal, name='add-proposal'),
    url(r'^form/(?P<proposal_id>[a-f0-9]{24,})/?$', views.edit_proposal, name='edit-proposal'),
    url(
        r'^form/(?P<proposal_id>[a-f0-9]{24,})/add_department_mass_change_to_proposal/?$',
        views.add_department_mass_change_to_proposal,
        name='add-department-mass-change',
    ),
    url(
        r'^form/(?P<proposal_id>[a-f0-9]{24,})/add_mass_schemes_recalculation_to_proposal/?$',
        views.add_mass_schemes_recalculation_to_proposal,
        name='add-mass-schemes-recalculation',
    ),
    url(
        r'^form/(?P<proposal_id>[a-f0-9]{24,})/add_mass_change_office_to_proposal/?$',
        views.add_mass_change_office_to_proposal,
        name='add-mass-change-office-to-proposal',
    ),

    url(r'^form/department/?$', views.department_data, name='department-data'),
    url(r'^form/departments_meta/?$', views.departments_meta, name='departments-meta'),

    url(r'^form/person/?$', views.person_data, name='person-data'),
    url(r'^form/persons_meta/?$', views.persons_meta, name='persons-meta'),

    url(r'^form/vacancy/?$', views.vacancy_data, name='vacancy-data'),
    url(r'^form/headcount/?$', views.headcount_data, name='headcount-data'),

    url(r'^form/load_persons/(?P<department_url>\w+)/?$', views.load_persons, name='load-persons'),
    url(r'^form/load_vacancies/(?P<department_url>\w+)/?$', views.load_vacancies, name='load-vacancies'),
    url(r'^form/load_headcounts/(?P<department_url>\w+)/?$', views.load_headcounts, name='load-headcounts'),

    url(r'^execute/(?P<proposal_id>[a-f0-9]{24,})/?$', views.execute, name='execute-proposal'),
    url(r'^delete/(?P<proposal_id>[a-f0-9]{24,})/?$', views.delete, name='delete-proposal'),
    url(
        r'^split_and_execute/(?P<proposal_id>[a-f0-9]{24,})/?$',
        views.split_and_execute,
        name='split-and-execute-proposal',
    ),
    url(r'^_debug_flow_context/(?P<proposal_id>[a-f0-9]{24,})/?$', views.debug_flow_context, name='debug-flow-context'),
]
