# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AllowedNet',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('macro_or_net', models.CharField(max_length=128, unique=True)),
                ('comment', models.CharField(max_length=512)),
            ],
        ),
        migrations.CreateModel(
            name='DeniedNet',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('macro_or_net', models.CharField(max_length=128, unique=True)),
                ('comment', models.CharField(max_length=512)),
            ],
        ),
        migrations.CreateModel(
            name='NetRule',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('mask', models.CharField(max_length=128)),
                ('left_begin', models.DecimalField(max_digits=64, decimal_places=0)),
                ('left_end', models.DecimalField(max_digits=64, decimal_places=0)),
                ('right_begin', models.DecimalField(max_digits=64, decimal_places=0)),
                ('right_end', models.DecimalField(max_digits=64, decimal_places=0)),
                ('is_allowed', models.BooleanField()),
            ],
            options={
                'ordering': ['left_begin', 'left_end', 'right_begin', 'right_end'],
            },
        ),
        migrations.AlterIndexTogether(
            name='netrule',
            index_together=set([('left_begin', 'left_end', 'right_begin', 'right_end')]),
        ),
    ]
