from django.db import models


class AllowedNet(models.Model):
    """
    Filled manually, by requests or tickets.
    """
    macro_or_net = models.CharField(max_length=128, unique=True)
    comment = models.CharField(max_length=512)


class DeniedNet(models.Model):
    macro_or_net = models.CharField(max_length=128, unique=True)
    comment = models.CharField(max_length=512)


class NetRule(models.Model):
    mask = models.CharField(max_length=128)

    left_begin = models.DecimalField(max_digits=64, decimal_places=0)
    left_end = models.DecimalField(max_digits=64, decimal_places=0)

    right_begin = models.DecimalField(max_digits=64, decimal_places=0)
    right_end = models.DecimalField(max_digits=64, decimal_places=0)

    is_allowed = models.BooleanField()

    class Meta:
        index_together = [
            ['left_begin', 'left_end', 'right_begin', 'right_end']
        ]
        ordering = ['left_begin', 'left_end', 'right_begin', 'right_end']
