from django.core.cache import cache

from staff.racktables.objects import YaIP
from staff.racktables.models import NetRule


_CACHE_TTL = 60


def _cache_key_for_ip(ip: str) -> str:
    return f'racktable_is_ip_internal_{ip}'


def is_ip_internal(ip) -> bool:
    cache_key = _cache_key_for_ip(ip)
    result = cache.get(cache_key)

    if result is not None:
        return result

    rule = YaIP(ip).as_rule()
    params = [rule.left_begin, rule.left_end, rule.right_begin, rule.right_end]

    res = (
        NetRule.objects
        .extra(
            where=[
                'racktables_netrule.left_begin <= CAST(%s AS DECIMAL(64))',
                'racktables_netrule.left_end >= CAST(%s AS DECIMAL(64))',
                'racktables_netrule.right_begin <= CAST(%s AS DECIMAL(64))',
                'racktables_netrule.right_end >= CAST(%s AS DECIMAL(64))',
            ],
            params=params,
        )
        .values_list('is_allowed', flat=True)
    )

    is_allowed = set(res) == {True}

    cache.set(cache_key, is_allowed, _CACHE_TTL)

    return is_allowed
